<?php


//Verify path is slant-terminated
//$mypath = "/home/evansg/giwiganz.com/Gander/cgi-php/";

$server   = "https://www.notams.faa.gov/common/nat.html";

if ( function_exists( 'curl_init' ) ){
	$ch = curl_init();
	//curl_setopt ($ch,CURLOPT_POST, true);
	curl_setopt ($ch,CURLOPT_URL, $server );
	//curl_setopt ($ch,CURLOPT_POSTFIELDS, $postdata);
	curl_setopt ($ch,CURLOPT_RETURNTRANSFER, 1 );
	curl_setopt ($ch,CURLOPT_CONNECTTIMEOUT, 5 );

	$content = curl_exec( $ch );
	curl_close( $ch );
}else{
	// see also http://www.php-mysql-tutorial.com/php-tutorial/php-read-remote-file.php
	//die( 'No method to read from remote server was found.' );
	die();
}

$fdata = "";
if($content != ""){
	$data = explode("\n",$content);
	foreach($data as $row){
		$sar = explode(" ",$row);
		if(strlen($sar[0]) == 1){
			$nat[] = $row;
			$fdata .= trim($row)."\n";
		}
	}
}

$tmi = gmdate("z.H");
$outputfile = $mypath."NATS/".$tmi."-nats.dat";
if(file_exists($outputfile)){
	unlink($outputfile);
}
$fp = fopen($outputfile,"w");
fwrite($fp,$fdata);
fclose($fp);

$i = 0;
foreach($nat as $row){
	$sar = explode(" ",$row);
	$track[$i] = $sar[0];
	
	$n = count($sar);
	for($j = 1; $j < $n; $j++){
		$track[$i] .= "||".$sar[$j].",";
		
		$laylox = wlookup($sar[$j]);
		if($laylox[0] == "NOT FOUND"){
			$track[$i].="999,999";
		}else{
			$track[$i].=sprintf("%s,%s",$laylox[0],$laylox[1]);
		}

	}
	$i++;


}

echo "<pre>\n";
print_r($track);

$n1 = count($track);
for($i = 0; $i < $n1; $i++){
	if($i > 0){
		$gmapstr .= ",\n";
	}else{
		$gmapstr = "var tracks = [\n";
	}


	$sar = explode("||",$track[$i]);
	$n2 = count($sar);
	$gmapstr .= "[";
	for($j = 1; $j < $n2; $j++){
		if($j > 1) $gmapstr .= ",";
		$wpd = explode(",",$sar[$j]);
		$gmapstr .= sprintf("['%s','%s',%s,%s]",$sar[0],$wpd[0],$wpd[1],$wpd[2]);

	}
	$gmapstr .= "]";
}
if($i > 0) $gmapstr .= "\n         ];\n";

echo "\n---\n".$gmapstr;




exit;







//Functions ===========================================================







function wlookup($waypoint){

	$waypoint = trim($waypoint);

$wdat[]="ALMES,58.5000,-63.0000";
$wdat[]="ATSIX,60.0000,-10.0000";
$wdat[]="AY,51.3863,-56.0963";
$wdat[]="BABAN,54.0000,-12.0000";
$wdat[]="BAGIT,61.0000,-15.0000";
$wdat[]="BALIX,59.0000,-10.0000";
$wdat[]="BANCS,45.6500,-52.1033";
$wdat[]="BEDRA,49.0000,-15.0000";
$wdat[]="BERUS,63.0000,-63.0000";
$wdat[]="BERUX,45.0000,-11.0000";
$wdat[]="BILPO,59.0000,-63.0000";
$wdat[]="BOBTU,44.1172,-52.8222";
$wdat[]="BOS,42.3643,-71.0052";
$wdat[]="BURAK,53.0000,-12.0000";
$wdat[]="CARAC,43.0000,-60.0000";
$wdat[]="CARPE,53.0833,-54.0833";
$wdat[]="CIMAT,59.5000,-63.0000";
$wdat[]="COLOR,46.6683,-52.5022";
$wdat[]="COPUR,59.7003,-67.0097";
$wdat[]="CRONO,51.3889,-52.7222";
$wdat[]="CYMON,49.7167,-55.0000";
$wdat[]="DENDU,50.5056,-52.0694";
$wdat[]="DEVOL,53.8950,-10.4347";
$wdat[]="DF,49.1800,-57.4572";
$wdat[]="DINIM,51.0000,-15.0000";
$wdat[]="DIXIS,45.0000,-10.0000";
$wdat[]="DOGAL,54.0000,-15.0000";
$wdat[]="DOLIP,52.0000,-12.0000";
$wdat[]="DOPHN,44.5500,-55.4833";
$wdat[]="DOTTY,50.6333,-55.5833";
$wdat[]="DUMRO,60.0000,-63.0000";
$wdat[]="ELPIN,56.0000,-12.0000";
$wdat[]="ELSET,60.5000,-63.0000";
$wdat[]="ERAKA,58.0000,-10.0000";
$wdat[]="ETARI,55.5000,-15.0000";
$wdat[]="ETIKI,48.0000,-8.7500";
$wdat[]="ETSOM,57.8978,-9.5000";
$wdat[]="FASSA,58.7003,-67.0097";
$wdat[]="FEDDY,61.7000,-67.0000";
$wdat[]="FLEXE,61.0000,-63.0000";
$wdat[]="FOXXE,54.4864,-59.2869";
$wdat[]="GINGA,56.9306,-9.5000";
$wdat[]="GIPER,51.0000,-12.0000";
$wdat[]="GOMUP,57.0000,-10.0000";
$wdat[]="GRIBS,61.5000,-63.0000";
$wdat[]="GUNSO,49.0703,-11.7442";
$wdat[]="HECKK,52.2222,-53.3694";
$wdat[]="HEMMI,45.0594,-55.5342";
$wdat[]="HIDRA,44.5000,-13.0000";
$wdat[]="HO,55.4639,-60.2139";
$wdat[]="IKMAN,62.5000,-63.0000";
$wdat[]="JAROM,44.1667,-54.8842";
$wdat[]="JEBBY,43.0675,-57.8669";
$wdat[]="JELCO,60.7000,-67.0000";
$wdat[]="JFK,40.6329,-73.7714";
$wdat[]="JT,48.5438,-58.7547";
$wdat[]="KAGLY,63.5000,-63.0000";
$wdat[]="KEF,63.9894,-22.6242";
$wdat[]="KENKI,65.0000,-63.0000";
$wdat[]="KENRI,59.0000,-60.8767";
$wdat[]="KENUK,50.0000,-12.0000";
$wdat[]="KOBEV,49.6722,-51.4667";
$wdat[]="KORIB,54.2556,-13.0000";
$wdat[]="LAKES,57.9858,-63.2667";
$wdat[]="LAPEX,47.0000,-8.0000";
$wdat[]="LIMRI,52.0000,-15.0000";
$wdat[]="LOACH,55.5167,-57.0156";
$wdat[]="LOGSU,48.7833,-51.0000";
$wdat[]="LOMTA,57.2033,-62.6200";
$wdat[]="LON,51.4686,-.4514";
$wdat[]="LOPVI,59.2667,-64.2500";
$wdat[]="MALOT,53.0000,-15.0000";
$wdat[]="MASIT,54.3333,-12.0000";
$wdat[]="MIBNO,65.5833,-62.5333";
$wdat[]="MIMKU,56.0000,-10.0000";
$wdat[]="MOATT,58.0250,-59.9283";
$wdat[]="MORAG,55.8561,-9.5000";
$wdat[]="MUDOS,43.5000,-13.0000";
$wdat[]="MUSVA,64.0000,-63.0000";
$wdat[]="MY,62.1068,-7.5877";
$wdat[]="NALDI,64.5000,-63.0000";
$wdat[]="NIBOG,55.0000,-10.0000";
$wdat[]="NOVEP,47.8361,-51.0000";
$wdat[]="NURSI,54.9703,-9.5000";
$wdat[]="ODLUM,55.0000,-12.0000";
$wdat[]="OMOKO,48.8425,-12.0000";
$wdat[]="OYSTR,53.8750,-54.9722";
$wdat[]="OZN,60.0572,-43.1597";
$wdat[]="PASAS,45.0000,-13.0000";
$wdat[]="PEPKI,59.7333,-61.6167";
$wdat[]="PIK,55.5062,-4.5773";
$wdat[]="PIKIL,56.0000,-15.0000";
$wdat[]="PIKIL,56.0000,-15.0000";
$wdat[]="PORGY,56.3167,-58.0822";
$wdat[]="PRAWN,57.2056,-59.1889";
$wdat[]="QX,48.9650,-54.6683";
$wdat[]="RAFIN,44.8833,-51.8050";
$wdat[]="RASIX,43.0000,-13.0000";
$wdat[]="RATSU,61.0000,-10.0000";
$wdat[]="REDBY,52.2492,-56.6014";
$wdat[]="REGHI,48.0000,-8.0000";
$wdat[]="RESNO,55.0000,-15.0000";
$wdat[]="RIBNO,60.0833,-65.1667";
$wdat[]="RIVAK,46.0000,-8.0000";
$wdat[]="RODBO,60.0833,-65.1667";
$wdat[]="RONPO,46.8833,-51.0000";
$wdat[]="SCROD,54.6167,-55.8667";
$wdat[]="SEPAL,47.0000,-8.7500";
$wdat[]="SHA,52.7175,-8.8836";
$wdat[]="SIVIR,46.0000,-8.7500";
$wdat[]="SOMAX,50.0000,-15.0000";
$wdat[]="STEAM,52.9983,-57.3417";
$wdat[]="SUNOT,57.0000,-15.0000";
$wdat[]="SUNOT,57.0000,-15.0000";
$wdat[]="TADEX,54.8564,-8.2333";
$wdat[]="TANTI,62.0000,-63.0000";
$wdat[]="TAPLU,60.0000,-61.9017";
$wdat[]="TEFFO,62.8000,-67.0000";
$wdat[]="TULTA,48.5839,-8.0000";
$wdat[]="UHA,61.0427,-69.6273";
$wdat[]="URTAK,45.8417,-51.0000";
$wdat[]="VALIE,53.6250,-58.1389";
$wdat[]="VENER,54.5000,-15.0000";
$wdat[]="VIBDI,58.8833,-60.7500";
$wdat[]="VIMLA,61.0000,-63.0000";
$wdat[]="VIXUN,48.1383,-53.6133";
$wdat[]="VODOR,44.9389,-51.0000";
$wdat[]="VP,58.0562,-68.4863";
$wdat[]="YAY,51.3939,-56.0839";
$wdat[]="YDF,49.2325,-57.2133";
$wdat[]="YDP,56.5333,-61.6917";
$wdat[]="YFB,63.7417,-68.4733";
$wdat[]="YFY,63.7333,-68.5480";
$wdat[]="YJI,67.5620,-64.0175";
$wdat[]="YJT,48.5825,-58.6692";
$wdat[]="YQX,48.9000,-54.5350";
$wdat[]="YR,53.3378,-60.3658";
$wdat[]="YT,47.6700,-52.8083";
$wdat[]="YVP,58.0961,-68.4272";
$wdat[]="YXP,66.1438,-65.7062";
$wdat[]="YYR,53.3197,-60.2947";
$wdat[]="YYT,47.4850,-52.8517";
$wdat[]="NETKI,55,-14";
$wdat[]="BEXET,54,-14";
$wdat[]="GISTI,53,-14";
$wdat[]="XETBO,52,-14";
$wdat[]="ELSOX,51,-14";
$wdat[]="SOORY,38.5,-60.267";
$wdat[]="ATSUR,50,-14";
$wdat[]="BALOO,34.41,-62.14";
$wdat[]="LAZEY,33.59,-61.49";
$wdat[]="NERTU,49,-14";
$wdat[]="UPGAS,51.4,-3.83";
$wdat[]="MERLY,51.33,-5";
$wdat[]="LESLU,50.42,-8";
$wdat[]="MALBY,51.59,-2.04";
$wdat[]="SM15W,50.683,-15.000";
$wdat[]="SM20W,50.833,-20.000";
$wdat[]="SM30W,50.500,-30.000";
$wdat[]="SM40W,49.267,-40.000";
$wdat[]="SM50W,47.050,-50.000";
$wdat[]="SM53W,46.167,-53.000";
$wdat[]="SM60W,44.233,-60.000";
$wdat[]="SM65W,42.767,-65.000";
$wdat[]="SM67W,42.000,-67.000";
$wdat[]="SN67W,40.417,-67.000";
$wdat[]="SN65W,41.667,-65.000";
$wdat[]="SN60W,43.117,-60.000";
$wdat[]="SN52W,45.167,-52.500";
$wdat[]="SN50W,45.900,-50.000";
$wdat[]="SN40W,48.167,-40.000";
$wdat[]="SN30W,49.433,-30.000";
$wdat[]="SN20W,49.817,-20.000";
$wdat[]="SN15W,49.683,-15.000";
$wdat[]="SO15W,48.667,-15.000";
$wdat[]="SO20W,48.800,-20.000";
$wdat[]="SO30W,48.367,-30.000";
$wdat[]="SO40W,47.067,-40.000";
$wdat[]="SO50W,44.750,-50.000";
$wdat[]="SO52W,44.167,-52.000";
$wdat[]="SO60W,42.000,-60.000";
$wdat[]="SOCA,48.983,-14.717";
$wdat[]="SP20W,46.817,-20.000";
$wdat[]="SP45N,45.000,-23.883";
$wdat[]="SP30W,41.600,-30.000";
$wdat[]="SP40W,34.367,-40.000";
$wdat[]="DOVEY,41.12,-67.000";
$wdat[]="JOBOC,40.12,-67.000";
$wdat[]="NUMBR,32.67,-61.192";
$wdat[]="SLATN,39.12,-67.000";
$wdat[]="WINGZ,31.64,-61.29";
$wdat[]="BILTO,56.5,-15";
$wdat[]="SOVED,56,-14";
$wdat[]="AGORI,57,-13";

	
	$laylox[0] = "NOT FOUND";
	foreach($wdat as $row){
		$sar = explode(",",$row);
		if($sar[0] == $waypoint){
			$laylox[0] = $sar[1];
			$laylox[1] = $sar[2];
			break;
		}
	}
	
	//Check for waypoints such as "53/30"
	if($laylox[0] == "NOT FOUND"){ 
		if(strpos($waypoint,"/") == 2){
			$laylox[0] = substr($waypoint,0,2);
			$laylox[1] = "-".substr($waypoint,3,2);
		}
	}
	
	return $laylox;

}




?>

