<?php

//Verify path is slant-terminated
$mypath = "/home/evansg/giwiganz.com/Gander/cgi-php/";


//Collect VATSIM data from a random server
$vserv[0] = "http://www.pcflyer.net/DataFeed/vatsim-data.txt";
$vserv[1] = "http://fsproshop.com/servinfo/vatsim-data.txt";
$vserv[2] = "http://info.vroute.net/vatsim-data.txt";
$vserv[3] = "http://data.vattastic.com/vatsim-data.txt";
$server   = $vserv[rand(0,3)];

if ( function_exists( 'curl_init' ) ){
	$ch = curl_init();
	//curl_setopt ($ch,CURLOPT_POST, true);
	curl_setopt ($ch,CURLOPT_URL, $server );
	//curl_setopt ($ch,CURLOPT_POSTFIELDS, $postdata);
	curl_setopt ($ch,CURLOPT_RETURNTRANSFER, 1 );
	curl_setopt ($ch,CURLOPT_CONNECTTIMEOUT, 5 );

	$content = curl_exec( $ch );
	curl_close( $ch );
}else{
	// see also http://www.php-mysql-tutorial.com/php-tutorial/php-read-remote-file.php
	//die( 'No method to read from remote server was found.' );
	die();
}

//0		   1   2		3		   4		 5		  6			7		 8			 9				  10
//callsign:cid:realname:clienttype:frequency:latitude:longitude:altitude:groundspeed:planned_aircraft:planned_tascruise:
//11				 12				  13				  14	 15			  16	 17			 18
//planned_depairport:planned_altitude:planned_destairport:server:protrevision:rating:transponder:facilitytype:
//19		  20			   21				  22			  23				 24
//visualrange:planned_revision:planned_flighttype:planned_deptime:planned_actdeptime:planned_hrsenroute:
//25				 26				 27				 28					29				30			  
//planned_minenroute:planned_hrsfuel:planned_minfuel:planned_altairport:planned_remarks:planned_route:
//31					 32						33						34						35
//planned_depairport_lat:planned_depairport_lon:planned_destairport_lat:planned_destairport_lon:atis_message:
//36					  37				 38		 39
//time_last_atis_received:time_logon:heading:QNH_iHg:QNH_Mb:

if($content != ""){
	$fdata = "";
	$data = explode("\n",$content);
	foreach($data as $str){
		$sar = explode(":",$str);
		if($sar[3] == "PILOT"){
			//callsign::lat::lon::eqpt::orig::altitude::dest::remarks::fplan
			$artcc = "";
			if(pnpoly_CZQX($sar[5], $sar[6]) == 1) $artcc = "Gander";
			if(pnpoly_EGGX($sar[5], $sar[6]) == 1) $artcc = "Shanwick";
			$fdata .= sprintf("%s::%s::%s::%s::%s::%s::%s::%s::%s::%s\n",$sar[0],$sar[5], $sar[6],$sar[9],$sar[11],$sar[12],$sar[13],$sar[29],$sar[30],$artcc);
		}
	}
}

$outputfile = $mypath."vatsim.dat";
if(file_exists($outputfile)){
	unlink($outputfile);
}
$fp = fopen($outputfile,"w");
fwrite($fp,$fdata);
fclose($fp);


exit;


//Functions ===========================================================


//GANDER OCEANIC AIRSPACE - returns 1 if within polygon
function pnpoly_CZQX($laty, $lonx)
{

	$verty = array(45.0,45.0,49.0,53.0,57.0,61.0,64.0,65.0,65.0,58.5,58.5,63.5,61.0);
	$vertx = array(-30.00,-51.00,-51.00,-54.00,-59.00,-63.00,-63.00,-60.00,-57.75,-50.00,-43.00,-39.00,-30.00);

	$ny = count($verty);
	$nx = count($vertx);

	if($ny != $nx){
		return -1;
	}else{
		$nvert = $nx;
	}
	
	$testx = $lonx;
	$testy = $laty;

	$c = 0;
	for($i = 0, $j = $nvert-1; $i < $nvert; $j = $i++){
		if ( (($verty[$i] > $testy) != ($verty[$j] > $testy)) && ($testx < ($vertx[$j]-$vertx[$i]) * ($testy-$verty[$i]) / ($verty[$j]-$verty[$i]) + $vertx[$i]) ) $c++;
	}
	return $c;
}

//SHANWICK OCEANIC AIRSPACE  - returns 1 if within polygon
function pnpoly_EGGX($laty, $lonx)
{

	$verty = array(61.00,61.00,54.57,54.00,51.00,51.00,45.00,45.00);
	$vertx = array(-30.0,-10.0,-10.0,-15.0,-15.0,-08.0 ,-08.0 ,-30.0);

	$ny = count($verty);
	$nx = count($vertx);

	if($ny != $nx){
		return -1;
	}else{
		$nvert = $nx;
	}

	$testx = $lonx;
	$testy = $laty;
	
	$c = 0;
	for ($i = 0, $j = $nvert-1; $i < $nvert; $j = $i++){
		if ( (($verty[$i] > $testy) != ($verty[$j] > $testy)) && ($testx < ($vertx[$j]-$vertx[$i]) * ($testy-$verty[$i]) / ($verty[$j]-$verty[$i]) + $vertx[$i]) ) $c++;
	}
	return $c;
}





?>

